if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

transmission_type               = enum_transmission_type.CVT;
transmission_gear_select        = enum_transmission_gear_select.ALPHAshift_CVT;
transmission_thermal_type       = enum_transmission_thermal_type.constant_temperature;
transmission_lockup_select      = enum_transmission_lockup_select.table_lockup;

transmission                    = class_REVS_CVT_transmission;
transmission.matrix_vintage     = enum_matrix_vintage.present;
transmission.name               = 'transmission_CVT'; 
transmission.rated_torque_Nm    = 250; 

transmission.gear                                       = class_REVS_gearbox;
transmission.gear.type                                  = enum_transmission_type.CVT;
transmission.gear.number                                = [    0.00000000,	  0.38000000,	   2.7300000,	 ]; 
transmission.gear.ratio                                 = [    0.00000000,	  0.38000000,	   2.7300000,	 ]; 
transmission.gear.inertia_kgm2                          = [    0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear.efficiency_norm.axis_1.breakpoints    = [    0.00000000,	   1.0000000,	 ]; 
transmission.gear.efficiency_norm.axis_1.signal         =  'gb_spd_in_radps'; 
transmission.gear.efficiency_norm.table                 = [    0.99000000,	  0.99000000,	 ]; 
transmission.gear.common_input_inertia_kgm2             =   0.025000000; 
transmission.gear.common_output_inertia_kgm2            =   0.025000000;

transmission.gear.input_torque_loss_Nm.axis_1.breakpoints       = [     20.000000,	   80.000000,	   90.000000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_1.signal            =  'trans_temp_degC'; 
transmission.gear.input_torque_loss_Nm.axis_2.breakpoints       = [    0.37500000,	  0.75000000,	   2.7500000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_2.extrapolate_above =  0; 
transmission.gear.input_torque_loss_Nm.axis_2.extrapolate_below =  1; 
transmission.gear.input_torque_loss_Nm.axis_2.signal            =  'gb_cmd_ratio'; 
transmission.gear.input_torque_loss_Nm.axis_3.breakpoints       = [     5.0000000,	   10.000000,	   20.000000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_3.signal            =  'gb_line_press_bar'; 
transmission.gear.input_torque_loss_Nm.axis_4.breakpoints       = [     104.71976,	   157.07963,	   209.43951,	   314.15927,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_4.signal            =  'gb_spd_in_radps'; 
transmission.gear.input_torque_loss_Nm.table = [];
transmission.gear.input_torque_loss_Nm.table(:,:,1,1) = [
   7.9650000,    6.0750000,    5.5080000, ;
   5.3100000,    4.0500000,    3.0600000, ;
   5.0445000,    3.8475000,    2.9070000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,1) = [
   11.880000,    9.4500000,    8.5860000, ;
   7.9200000,    6.3000000,    4.7700000, ;
   7.5240000,    5.9850000,    4.5315000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,3,1) = [
   20.250000,    16.740000,    14.904000, ;
   13.500000,    11.160000,    8.2800000, ;
   12.825000,    10.602000,    7.8660000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,1,2) = [
   9.0450000,    6.8850000,    6.1560000, ;
   6.0300000,    4.5900000,    3.4200000, ;
   5.7285000,    4.3605000,    3.2490000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,2) = [
   12.825000,    10.260000,    9.5580000, ;
   8.5500000,    6.8400000,    5.3100000, ;
   8.1225000,    6.4980000,    5.0445000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,3,2) = [
   21.330000,    17.415000,    14.904000, ;
   14.220000,    11.610000,    8.2800000, ;
   13.509000,    11.029500,    7.8660000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,1,3) = [
   9.9900000,    7.2900000,    6.4800000, ;
   6.6600000,    4.8600000,    3.6000000, ;
   6.3270000,    4.6170000,    3.4200000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,3) = [
   13.365000,    10.260000,    9.5580000, ;
   8.9100000,    6.8400000,    5.3100000, ;
   8.4645000,    6.4980000,    5.0445000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,3,3) = [
   22.005000,    17.550000,    15.390000, ;
   14.670000,    11.700000,    8.5500000, ;
   13.936500,    11.115000,    8.1225000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,1,4) = [
   12.960000,    8.7750000,    7.6140000, ;
   8.6400000,    5.8500000,    4.2300000, ;
   8.2080000,    5.5575000,    4.0185000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,4) = [
   16.065000,    11.475000,    10.692000, ;
   10.710000,    7.6500000,    5.9400000, ;
   10.174500,    7.2675000,    5.6430000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,3,4) = [
   22.815000,    18.630000,    16.524000, ;
   15.210000,    12.420000,    9.1800000, ;
   14.449500,    11.799000,    8.7210000, ]; 

transmission.gear.output_torque_loss_Nm.axis_1.breakpoints  = [    0.00000000,	   1.0000000,	 ]; 
transmission.gear.output_torque_loss_Nm.axis_1.signal       =  'gb_spd_out_radps'; 
transmission.gear.output_torque_loss_Nm.table               = [    0.00000000,	  0.00000000,	 ]; 

transmission.gear.shift_duration_secs =    1.00000000; 

transmission.torque_converter                           = class_REVS_torque_converter;
transmission.torque_converter.pump_inertia_kgm2         =   0.039000000; 
transmission.torque_converter.turbine_inertia_kgm2      =   0.019500000; 
transmission.torque_converter.speed_ratio               = [    0.00000000,	;   0.10000000,	;   0.20000000,	;   0.30000000,	;   0.40000000,	;   0.50000000,	;   0.60000000,	;   0.70000000,	;   0.75000000,	;   0.80000000,	;   0.85000000,	;   0.90000000,	;   0.92000000,	;   0.94000000,	 ]; 
transmission.torque_converter.drive_torque_ratio        = [     2.0000000,	;    1.9000000,	;    1.8000000,	;    1.7000000,	;    1.6000000,	;    1.5000000,	;    1.3000000,	;    1.2000000,	;    1.1000000,	;    1.1000000,	;    1.0000000,	;   0.97000000,	;   0.97000000,	;   0.95000000,	 ]; 
transmission.torque_converter.drive_k_factor_rpmpsqrtNm = [     159.00000,	;    155.00000,	;    156.00000,	;    157.00000,	;    159.00000,	;    162.00000,	;    165.00000,	;    173.00000,	;    178.00000,	;    184.00000,	;    192.00000,	;    223.00000,	;    246.00000,	;    282.00000,	 ]; 
transmission.torque_converter.decel_torque_ratio        = [    0.96000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	 ]; 
transmission.torque_converter.decel_k_factor_rpmpsqrtNm = [     307.80000,	;    307.80000,	;    307.80000,	;    307.80000,	;    307.80000,	;    307.80000,	;    307.80000,	;    307.80000,	;    322.30000,	;    344.70000,	;    381.40000,	;    446.00000,	;    469.90000,	;    492.70000,	 ]; 
transmission.torque_converter.lockup_duration_secs      =    0.30000000; 
transmission.torque_converter.lockup_efficiency_norm    =     1.0000000; 
transmission.torque_converter.unlock_duration_secs      =    0.30000000; 

transmission.control                                                = class_REVS_CVT_control;
transmission.control.line_press_rate_limit_barps                    =     35.000000; 
transmission.control.line_pressure_map_bar.axis_1.breakpoints       = [    0.37500000,	   2.7500000,	 ]; 
transmission.control.line_pressure_map_bar.axis_1.extrapolate_above =  1; 
transmission.control.line_pressure_map_bar.axis_1.extrapolate_below =  1; 
transmission.control.line_pressure_map_bar.axis_1.signal            =  'gb_cmd_ratio'; 
transmission.control.line_pressure_map_bar.axis_2.breakpoints       = [    -250.00000,	  -140.00000,	  -70.000000,	  0.00000000,	   70.000000,	   140.00000,	   250.00000,	 ]; 
transmission.control.line_pressure_map_bar.axis_2.signal            =  'tc_trq_in_Nm'; 
transmission.control.line_pressure_map_bar.axis_3.breakpoints       = [    0.00000000,	 0.010000000,	 ]; 
transmission.control.line_pressure_map_bar.axis_3.signal            =  'driver_brk_norm';
transmission.control.line_pressure_map_bar.table = [];
transmission.control.line_pressure_map_bar.table(:,:,1) = [
   17.761900,    9.9214400,    5.0448000,    5.0000000,    5.0448000,    9.9214400,    17.761900, ;
   42.355300,    23.752600,    11.876300,    9.6000000,    11.876300,    23.752600,    42.355300, ]; 
transmission.control.line_pressure_map_bar.table(:,:,2) = [
   17.761900,    9.9214400,    6.0000000,    6.0000000,    6.0000000,    9.9214400,    17.761900, ;
   54.767700,    30.713400,    15.356700,    12.700000,    15.356700,    30.713400,    54.767700, ];

transmission.control.auto_neutral_enable                =  1; 
transmission.control.auto_neutral_delay_secs            =  0.00000000; 
transmission.control.auto_neutral_warmup_condition      =  '1'; 
transmission.control.auto_neutral_warmup_temp_degC      =  50.000000; 
transmission.control.auto_neutral_warmup_duration_secs  =  100.00000;

transmission.thermal.temperature_degC =     90.000000; 

transmission.pump_loss_Nm.axis_1.breakpoints        = [     20.000000,	   80.000000,	   90.000000,	 ]; 
transmission.pump_loss_Nm.axis_1.signal             =  'trans_temp_degC'; 
transmission.pump_loss_Nm.axis_2.breakpoints        = [     5.0000000,	   10.000000,	   30.000000,	 ]; 
transmission.pump_loss_Nm.axis_2.extrapolate_above  =  1; 
transmission.pump_loss_Nm.axis_2.signal             =  'gb_line_press_bar'; 
transmission.pump_loss_Nm.axis_3.breakpoints        = [     105.00000,	   157.00000,	   209.00000,	   314.00000,	 ]; 
transmission.pump_loss_Nm.axis_3.signal             =  'tc_spd_in_radps'; 
transmission.pump_loss_Nm.table(:,:,1) = [
   1.7700000,    3.1860000,    8.7320000, ;
   1.5000000,    2.7000000,    7.4000000, ;
   1.4550000,    2.6190000,    7.1780000, ]; 
transmission.pump_loss_Nm.table(:,:,2) = [
   2.0060000,    3.3040000,    8.6140000, ;
   1.7000000,    2.8000000,    7.3000000, ;
   1.6490000,    2.7160000,    7.0810000, ]; 
transmission.pump_loss_Nm.table(:,:,3) = [
   2.2420000,    3.5400000,    8.8500000, ;
   1.9000000,    3.0000000,    7.5000000, ;
   1.8430000,    2.9100000,    7.2750000, ]; 
transmission.pump_loss_Nm.table(:,:,4) = [
   2.5960000,    4.0120000,    9.0860000, ;
   2.2000000,    3.4000000,    7.7000000, ;
   2.1340000,    3.2980000,    7.4690000, ]; 

transmission.gear_strategy                                      = class_REVS_ALPHAshift_CVT;
transmission.gear_strategy.min_bsfc_speed_rapds                 = [     42.049437,	   64.855911,	   88.375087,	   104.76724,	   124.72291,	   133.98804,	   146.10398,	   148.95478,	   161.07072,	   167.48504,	   183.16450,	   188.86611,	   203.12016,	   218.79961,	   230.20285,	   235.90447,	   250.15851,	   265.12526,	   279.37931,	   293.63335,	   307.88740,	   314.30172,	   320.00334,	   333.54468,	   347.08603,	   360.62737,	   371.31791,	   377.01953,	   381.29574,	   391.27357,	   397.68789,	   398.40060,	   403.38951,	   414.08005,	   425.48328,	   439.73733,	   453.99138,	   468.24542,	   483.21217,	   497.46622,	   513.14567,	   528.11242,	   554.48240,	   590.83022,	   643.57019,	 ]; 
transmission.gear_strategy.min_bsfc_power_W                     = [     2500.0000,	   5000.0000,	   7500.0000,	   10000.000,	   12500.000,	   15000.000,	   17500.000,	   20000.000,	   22500.000,	   25000.000,	   27500.000,	   30000.000,	   32500.000,	   35000.000,	   37500.000,	   40000.000,	   42500.000,	   45000.000,	   47500.000,	   50000.000,	   52500.000,	   55000.000,	   57500.000,	   60000.000,	   62500.000,	   65000.000,	   67500.000,	   70000.000,	   72500.000,	   75000.000,	   82500.000,	   85000.000,	   87500.000,	   90000.000,	   92500.000,	   95000.000,	   97500.000,	   100000.00,	   102500.00,	   105000.00,	   107500.00,	   110000.00,	   112500.00,	   115000.00,	   117500.00,	 ]; 
transmission.gear_strategy.min_speed_radps.axis_1.breakpoints   = [    0.00000000,	   10.000000,	   11.111111,	 ]; 
transmission.gear_strategy.min_speed_radps.axis_1.signal        =  'veh_spd_mps'; 
transmission.gear_strategy.min_speed_radps.axis_2.breakpoints   = [    0.00000000,	 0.010000000,	 ]; 
transmission.gear_strategy.min_speed_radps.axis_2.signal        =  'driver_acl_norm'; 
transmission.gear_strategy.min_speed_radps.table = [
   115.19173,    120.42772, ;
   115.19173,    120.42772, ;
   120.42772,    120.42772, ]; 

transmission.tcc_strategy.lock_map_load     = [    0.00000000,	;    5.0000000,	;    25.000000,	;    40.000000,	 ]'; 
transmission.tcc_strategy.lock_map_speed    = [
   99.000000,    99.000000, ;
   13.000000,    13.000000, ;
   13.000000,    13.000000, ;
   50.000000,    50.000000, ]; 
transmission.tcc_strategy.lockup_allowed        =  1; 
transmission.tcc_strategy.lockup_delay_secs     =    0.25000000; 
transmission.tcc_strategy.lockup_load_source    = enum_load_source.driver_acl_pct;
transmission.tcc_strategy.lockup_speed_source   = enum_speed_source.vehicle_speed_mph;
transmission.tcc_strategy.unlock_map_load       = [    0.00000000,	   1.0000000,	   10.000000,	 ]; 
transmission.tcc_strategy.unlock_map_speed      = [
   50.000000,    50.000000, ;
   9.0000000,    9.0000000, ;
   9.0000000,    9.0000000, ];
